ScriptName JBulk_WeaponContainer extends ObjectReference

Int Function AcceptItem(Form akBaseItem, int aiItemCount, ObjectReference akItemReference, ObjectReference akSourceContainer)
    bool ref = akItemReference != None
    int error = -1
    if ref
        error = -2
    endif
    Weapon baseWeapon = akBaseItem as Weapon

    if !baseWeapon
        return error
    endif

    if baseWeapon.GetEnchantment()
        return error
    endif

    if ref
		if akItemReference.GetEnchantment()
			return error
		endif
    endif

    return 1
EndFunction


Event OnItemAdded(Form akBaseItem, int aiItemCount, ObjectReference akItemReference, ObjectReference akSourceContainer)
    int accept = AcceptItem(akBaseItem, aiItemCount, akItemReference, akSourceContainer)
	if accept < 0
		Debug.Notification("Only unenchanted weapons are allowed.")
	endif
    if accept == -1
        RemoveItem(akBaseItem, aiItemCount, true, akSourceContainer)
    elseif accept == -2
        RemoveItem(akItemReference, 1, true, akSourceContainer)
    endif
EndEvent
